//////////////////////////////////////////////////////////////////////////////
//    ##      #####   ######   ######     ##     ####     #######  ##  ##   //
//   ####    ##   ##  # ## #    ##  ##   ####     ##       ##   #  ##  ##   //
//  ##  ##   #          ##      ##  ##  ##  ##    ##       ## #     ####    //
//  ##  ##    #####     ##      #####   ##  ##    ##       ####      ##     //
//  ######        ##    ##      ## ##   ######    ##   #   ## #     ####    //
//  ##  ##   ##   ##    ##      ##  ##  ##  ##    ##  ##   ##   #  ##  ##   //
//  ##  ##    #####    ####    #### ##  ##  ##   #######  #######  ##  ##   //
//--------------------------------------------------------------------------//
//--------------------------------------------------------------------------//
//      #####   ##   ##    ##     #####    #######  ######    #####         //
//     ##   ##  ##   ##   ####     ## ##    ##   #   ##  ##  ##   ##        //
//     #        ##   ##  ##  ##    ##  ##   ## #     ##  ##  #              //
//      #####   #######  ##  ##    ##  ##   ####     #####    #####         //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//          ##  ##   ##  ######    ##  ##   ## #     ## ##        ##        //
//     ##   ##  ##   ##  ##  ##    ## ##    ##   #   ##  ##  ##   ##        //
//      #####   ##   ##  ##  ##   #####    #######  #### ##   #####         //
/////(BSL Shaders Edit)//////////////////////////////////////By LexBoosT//////

//Settings//
#include "/lib/settings.glsl"

//Varyings//
varying vec2 texCoord;

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

//Uniforms//
uniform sampler2D texture;

//Program//
void main(){
	//Texture
	vec4 albedo = texture2D(texture, texCoord);
	albedo.rgb = pow(albedo.rgb,vec3(2.2)) * 2.25;
	
	#ifdef WHITE_WORLD
	#ifdef DAMAGED_BLOCKW
	albedo.a = 0.0;
	#endif
	#endif
	
	#ifdef RETIRE_TEXTURE_CASSE
	albedo.a = 0.0;
	#endif
	
	/* DRAWBUFFERS:0 */
	gl_FragData[0]=albedo;
}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

//Uniforms//
#if AA>1
uniform int frameCounter;
uniform float viewWidth,viewHeight;
#endif

uniform float frameTimeCounter;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

//Includes//
#if AA>1
#include "/lib/util/jitter.glsl"
#endif

#ifdef WORLD_CURVATURE
#include "/lib/vertex/worldCurvature.glsl"
#endif

//Program//
void main(){
	texCoord=(gl_TextureMatrix[0]*gl_MultiTexCoord0).xy;
	
	vec4 position=gbufferModelViewInverse*gl_ModelViewMatrix*gl_Vertex;
	
	#ifdef WORLD_CURVATURE
	position.y-=WorldCurvature(position.xz);
	#else
	gl_Position=ftransform();
	#endif
	
	#ifdef MOUVEMENT_CAM
	position+=vec4(.03*sin(frameTimeCounter*3.*SPEED_MOOVE),.015*cos(frameTimeCounter*4.*SPEED_MOOVE),0.,0.)*gbufferModelView;
	#endif
	
	gl_Position=gl_ProjectionMatrix*gbufferModelView*position;
	
	#if AA>1
	gl_Position.xy=TAAJitter(gl_Position.xy,gl_Position.w);
	#endif
}

#endif